{*
* 2007-2016 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2016 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}
{if isset($orderProducts) && count($orderProducts) > 0}
	<div class="crossseling-content">
		<h3 class=" page-product-heading cartcrossselling_title">{l s='Customers who bought this product also bought:' mod='blockcart'}</h3>
		{assign var='sliderFor' value=count($orderProducts)}
		{if $sliderFor > 4}
			<div class="customNavigation">
				<a class="btn prev cartcrossselling_prev"></a>
				<a class="btn next cartcrossselling_next"></a>
			</div>
		{/if}
		<div id="block_content">
			<ul id="cartcrossselling-carousel" class="tm-carousel product_list">
				{foreach from=$orderProducts item='product' name=orderProduct}
					<li class="item">
						<div class="product-container" itemscope itemtype="https://schema.org/Product">
							<div class="left-block">
								<div class="product-image-container">
									<a class="product_img_link" href="{$product.link|escape:'html':'UTF-8'}" title="{$product.name|escape:'html':'UTF-8'}" itemprop="url">
										<img class="replace-2x img-responsive" src="{$link->getImageLink($product.link_rewrite, $product.id_image, 'home_default')|escape:'html':'UTF-8'}" alt="{if !empty($product.legend)}{$product.legend|escape:'html':'UTF-8'}{else}{$product.name|escape:'html':'UTF-8'}{/if}" title="{if !empty($product.legend)}{$product.legend|escape:'html':'UTF-8'}{else}{$product.name|escape:'html':'UTF-8'}{/if}" {if isset($homeSize)} width="{$homeSize.width}" height="{$homeSize.height}"{/if} itemprop="image" />
										{hook h="displayTmHoverImage" link_rewrite=$product.link_rewrite id_product=$product.id_product}
									</a>
								</div>
							</div>
							<div class="right-block">	
							{capture name='displayProductListReviews'}{hook h='displayProductListReviews' product=$product}{/capture}
								{if $smarty.capture.displayProductListReviews}
									<div class="hook-reviews">
									{hook h='displayProductListReviews' product=$product}
									</div>
								{/if}		
								<h5 itemprop="name">
									{if isset($product.pack_quantity) && $product.pack_quantity}{$product.pack_quantity|intval|cat:' x '}{/if}
									<a class="product-name" href="{$product.link|escape:'html':'UTF-8'}" title="{$product.name|escape:'html':'UTF-8'}" itemprop="url" >
										{$product.name|truncate:45:'...'|escape:'html':'UTF-8'}
									</a>
								</h5>
								
								{if (!$PS_CATALOG_MODE AND ((isset($product.show_price) && $product.show_price) || (isset($product.available_for_order) && $product.available_for_order)))}
									<div class="content_price">
										{if isset($product.show_price) && $product.show_price && !isset($restricted_country_mode)}
														{hook h="displayProductPriceBlock" product=$product type='before_price'}
											<span class="price product-price">
												{if !$priceDisplay}{convertPrice price=$product.price}{else}{convertPrice price=$product.price_tax_exc}{/if}
											</span>
											{if $product.price_without_reduction > 0 && isset($product.specific_prices) && $product.specific_prices && isset($product.specific_prices.reduction) && $product.specific_prices.reduction > 0}
												{hook h="displayProductPriceBlock" id_product=$product.id_product type="old_price"}
												{if $product.specific_prices.reduction_type == 'percentage'}
													<span class="price-percent-reduction">-{$product.specific_prices.reduction * 100}%</span>
												{/if}
												{hook h="displayProductPriceBlock" product=$product type="old_price"}
												<span class="old-price product-price">
													{displayWtPrice p=$product.price_without_reduction}
												</span>
											{/if}
											{hook h="displayProductPriceBlock" product=$product type="price"}
											{hook h="displayProductPriceBlock" product=$product type="unit_price"}
											{hook h="displayProductPriceBlock" product=$product type='after_price'}
										{/if}
									</div>
								{/if}
								<div class="button-container">
									{if (!isset($product.customization_required) || !$product.customization_required) && ($product.allow_oosp || $product.quantity > 0) && !$PS_CATALOG_MODE}
										<a class="exclusive button ajax_add_to_cart_button" href="{$link->getPageLink('cart', true, NULL, "qty=1&amp;id_product={$product.id_product|intval}&amp;token={$static_token}&amp;add")|escape:'html':'UTF-8'}" data-id-product="{$product.id_product|intval}" title="{l s='Add to cart' mod='crossselling'}">
											<span>{l s='Add to cart'}</span>
										</a>
										{hook h='displayProductListFunctionalButtons' product=$orderProduct}
										{if isset($comparator_max_item) && $comparator_max_item}
											<div class="compare">
												<a class="add_to_compare" href="{$orderProduct.link|escape:'html':'UTF-8'}" data-id-product="{$orderProduct.id_product}">{l s='Add to Compare'}</a>
											</div>
										{/if}
										{if isset($quick_view) && $quick_view}
										<a class="quick-view" href="{$orderProduct.link|escape:'html':'UTF-8'}" rel="{$orderProduct.link|escape:'html':'UTF-8'}">
											<span>{l s='Quick view'}</span>
										</a>
										{/if}
									{/if}
								</div>
							</div>
						</div><!-- .product-container> -->
					</li>
				{/foreach}
			</ul>
		</div>
	</div>
{/if}